
public abstract class Transfer {
	
	public Transfer() {
		
	}
	
	/** transfers val amount of money from account a1 to account a2 **/
	public static void transfer(Account a1, Account a2, double val) {
		double val1 = a1.getBalance();
		double val2 = a2.getBalance();
		
		double creditLimit = 0;
		boolean isCredit   = false;
		double creditCut   = 0;
		
		if (a1 instanceof CreditCardAccount) {
			CreditCardAccount a3 = (CreditCardAccount) a1;
			creditLimit = a3.getCreditLimit();
			
			// give the credit card company its cut
			CreditCardCompany ccco = (CreditCardCompany) a3.getLocation();
			creditCut = ccco.getCut() * val;
			ccco.setAssets(ccco.getAssets()+creditCut);
			isCredit = true;
		}
		
		// check if we have enough money or are over credit limit
		if (val1 < val || ( isCredit &&  creditLimit < val1-val )) {
			System.out.println("Not enough money to make transfer");
			return;
		}
		
		a1.setBalance(val1-val);
		a2.setBalance(val2+val-creditCut);
	}
	
	/** transfers all the money in account a1 to account a2 **/
	public static void transfer(Account a1, Account a2) {
		double val1 = a1.getBalance();
		transfer(a1,a2,val1);
	}
	
	/** transfers val amount of money from account a to person p **/
	public static void transfer(Account a, Person p, double val) {
		double val1 = a.getBalance();
		double val2 = p.getPocketMoney();
		
		double creditLimit = 0;
		boolean isCredit   = false;
		double creditCut   = 0;
		
		if (a instanceof CreditCardAccount) {
			CreditCardAccount a3 = (CreditCardAccount) a;
			creditLimit = a3.getCreditLimit();
			
			// give the credit card company its cut
			CreditCardCompany ccco = (CreditCardCompany) a3.getLocation();
			creditCut = ccco.getCut() * val;
			ccco.setAssets(ccco.getAssets()+creditCut);
			isCredit = true;
		}
		
		// check if we have enough money or are over credit limit
		if (val1 < val || ( isCredit &&  creditLimit < val1-val )) {
			System.out.println("Not enough money to make transfer");
			return;
		}
		
		a.setBalance(val1-val);
		p.setPocketMoney(val2+val-creditCut);
	}
	
	/** transfers all the money in account a to person p **/
	public static void transfer(Account a, Person p) {
		double val1 = a.getBalance();
		transfer(a,p,val1);
	}
	
	/** transfers val amount of money from person p to account a **/
	public static void transfer(Person p, Account a, double val) {
		double val2 = a.getBalance();
		double val1 = p.getPocketMoney();
		
		if (val1 < val) {
			System.out.println("Not enough money to make transfer");
			return;
		}
		
		a.setBalance(val2+val);
		p.setPocketMoney(val1-val);
	}
	
	/** transfers all the money from person p to account a **/
	public static void transfer(Person p, Account a) {
		double val1 = p.getPocketMoney();
		transfer(p,a,val1);
	}
	
	/** transfers val amount of money from person p1 to person p2 **/
	public static void transfer(Person p1, Person p2, double val) {
		double val1 = p1.getPocketMoney();
		double val2 = p2.getPocketMoney();
		
		if (val1 < val) {
			System.out.println("Not enough money to make transfer");
			return;
		}
		
		p1.setPocketMoney(val1-val);
		p2.setPocketMoney(val2+val);
	}
	
	/** transfers all the money in account p1 to account p2 **/
	public static void transfer(Person p1, Person p2) {
		double val1 = p1.getPocketMoney();
		transfer(p1,p2,val1);
	}
	
	/** transfers val amount of money from person p to nobody **/
	public static void transfer(Person p, double val) {
		double val1 = p.getPocketMoney();
		
		if (val1 < val) {
			System.out.println("Not enough money to make transfer");
			return;
		}
		
		p.setPocketMoney(val1-val);
	}
	

}
